<?php

namespace App\Http\Controllers;

use App\Services\EmailService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ContatoController extends Controller
{
    protected $emailService;
    public function __construct(EmailService $emailService)
    {
        $this->emailService = $emailService;
    }
    public function index() {
        return view('public.contact');
    }

    public function sendMail(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string',
            'subject' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'message' => 'required|string',
            'g-recaptcha-response' => 'required|string',
        ], [
        'name.required' => 'O campo nome é obrigatório.',
            'phone.required' => 'O campo telefone é obrigatório.',
            'subject.required' => 'O campo assunto é obrigatório.',
            'email.required' => 'O campo e-mail é obrigatório.',
            'message.required' => 'Por favor, escreva sua mensagem.',
        ]);

        // Validação do reCAPTCHA v3
        $response = Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify', [
            'secret' => config('services.recaptcha.v3_secret_key'),
            'response' => $request->input('g-recaptcha-response'),
            'remoteip' => $request->ip(),
        ]);

        $recaptchaData = $response->json();

        if (!isset($recaptchaData['success']) || $recaptchaData['success'] !== true || $recaptchaData['score'] < 0.5) {
            return back()->withErrors(['captcha' => 'Falha na verificação do reCAPTCHA. Tente novamente.']);
        }

        // Continuação do envio de e-mail
        $this->emailService->sendEmail(
            config('mail.mailAddress.email_contact'),
            'Contato',
            'emails.send-contact', [
            'name' => $request->post('name'),
            'phone' => $request->post('phone'),
            'email' => $request->post('email'),
            'msg' => $request->post('message'),
        ],
        );

        return redirect()->back()->with('success', 'Obrigado por entrar em contato!');
    }


}
