<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    @include('public.components.meta-tags')
    <!-- Page Title -->
    <title>Agapi | Ultrassonografia e Medicina Fetal - Contato</title>
    <!-- Favicon Icon -->
    @include('public.components.favicon')

    @include('public.components.styles')
</head>
<body>
<!-- Header Start -->
@include('public.components.navbar')
<!-- Header End -->

<!-- Page Header Section Start -->
<div class="page-header bg-section parallaxie">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <!-- Page Header Box Start -->
                <div class="page-header-box">
                    <h1 class="text-anime-style-2" data-cursor="-opaque">Contato</h1>
                    <nav class="wow fadeInUp" data-wow-delay="0.25s">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">home</a></li>
                            <li class="breadcrumb-item">/</li>
                            <li class="breadcrumb-item active" aria-current="page"><span>Contato</span></li>
                        </ol>
                    </nav>
                </div>
                <!-- Page Header Box End -->
            </div>
        </div>
    </div>
</div>
<!-- Page Header Section End -->

<!-- Hero Info Section Start -->
<div class="page-contact-us">
    <div class="container">
        <div class="col-lg-12">
            <!-- Hero Info List Start -->
            <div class="contact-info-list">
                <!-- Hero Info Item Start -->
                <div class="hero-info-item">
                    <div class="hero-info-header">
                        <h3>Funcionamento</h3>
                        <img src="{{ asset('assets/images/icon-clock.svg') }}" alt="...">
                    </div>
                    <div class="hero-info-body">
                        <ul>
                            <li><span>Segunda - Sexta</span>08:00 - 18:00</li>
                        </ul>
                    </div>
                </div>
                <!-- Hero Info Item End -->

                <!-- Hero Info Item Start -->
                <div class="hero-info-item">
                    <div class="hero-info-header">
                        <h3>Endereço</h3>
                        <img src="{{ asset('assets/images/icon-location.svg') }}" alt="...">
                    </div>
                    <div class="hero-info-body">
                        <p>Rua 40 Número 2 - Shopping 33, Torre 5 (Sala 1110 e 1111), Vila Santa Cecília, Volta Redonda</p>
                    </div>
                </div>
                <!-- Hero Info Item End -->

                <!-- Hero Info Item Start -->
                <div class="hero-info-item">
                    <div class="hero-info-header">
                        <h3>Contato</h3>
                        <img src="{{ asset('assets/images/icon-phone.svg') }}" alt="...">
                    </div>
                    <div class="hero-info-body">
                        <p><a href="tel:24998386145">(24) 99838-6145</a></p>
                        <p><a href="mailto:agenda@agapidiagnósticos.com">agenda@agapidiagnósticos.com</a></p>
                    </div>
                </div>
                <!-- Hero Info Item End -->
            </div>
            <!-- Hero Info List End -->
        </div>

        <div class="col-lg-12">
            <!-- Contact Form Section Start -->
            <div class="contact-form-section">
                <!-- Google Map Start -->
                <div class="google-map-iframe">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3685.6174261074007!2d-44.1033178!3d-22.518532699999998!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x9e9873dcf72a67%3A0x80934a44a96816c0!2sShopping%2033%20Torre%20I!5e0!3m2!1spt-BR!2sbr!4v1746661952876!5m2!1spt-BR!2sbr" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
                <!-- Google Map End -->

                <!-- Contact Us Form Start -->
                <div class="contact-us-form">
                    <!-- Section Title Start -->
                    <div class="section-title">
                        <h2 class="text-anime-style-2" data-cursor="-opaque">Fale <span>Conosco</span></h2>
                    </div>
                    <!-- Section Title End -->

                    <!-- Contact Form Start -->
                    <div class="contact-form">
                        <!-- Contact Form Start -->
                        <form id="contactForm" action="#" method="POST" data-toggle="validator" class="wow fadeInUp" data-wow-delay="0.2s">
                            <div class="row">
                                <div class="form-group col-md-12 mb-4">
                                    <input type="text" name="fname" class="form-control" id="fname" placeholder="Nome" required>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="form-group col-md-6 mb-4">
                                    <input type="email" name ="email" class="form-control" id="email" placeholder="E-mail" required>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="form-group col-md-6 mb-4">
                                    <input type="text" name="phone" class="form-control" id="phone" placeholder="Telefone" required>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="form-group col-md-12 mb-5">
                                    <textarea name="message" class="form-control" id="message" rows="3" placeholder="Digite a sua mensagem..."></textarea>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="col-md-12">
                                    <button type="submit" class="btn-default">Enviar Mensagem</button>
                                    <div id="msgSubmit" class="h3 hidden"></div>
                                </div>
                            </div>
                        </form>
                        <!-- Contact Form End -->
                    </div>
                    <!-- Contact Form End -->
                </div>
                <!-- Contact Us Form End -->
            </div>
            <!-- Contact Form Section End -->
        </div>
    </div>
</div>
<!-- Hero Info Section End -->


<!-- Footer Start -->
@include('public.components.footer')
<!-- Footer End -->

@include('public.components.scripts')
</body>

</html>
