<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    @include('public.components.meta-tags')
    <!-- Page Title -->
    <title>Agapi | Ultrassonografia e Medicina Fetal</title>
    <!-- Favicon Icon -->
    @include('public.components.favicon')

    @include('public.components.styles')
</head>
<body>
<!-- Header Start -->
@include('public.components.navbar')
<!-- Header End -->

<div class="hero bg-section dark-section parallaxie">
    <div class="hero-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="hero-content">
                        <div class="section-title">
                            <h3 class="wow fadeInUp">Ultrossonografia e Medicina Fetal</h3>
                            <h1 class="text-anime-style-2" data-cursor="-opaque">
                                Registrando os sinais do <span>amor</span> mais puro
                            </h1>
                            <p class="wow fadeInUp" data-wow-delay="0.2s">
                                Com carinho e tecnologia, acompanhamos cada passo da sua gestação, proporcionando
                                segurança, afeto e alegria para você e sua família desde o primeiro instante do seu
                                bebê. Aqui, cada vida é celebrada com amor!
                            </p>
                        </div>
                        <div class="hero-content-list wow fadeInUp" data-wow-delay="0.4s">
                            <ul>
                                <li>Qualidade</li>
                                <li>Profissionais Qualificados</li>
                            </ul>
                        </div>
                        <div style="padding-top: 50px;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- About Us Section Start -->
<div class="about-us">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="about-us-images">
                    <div class="about-us-img-1">
                        <figure class="image-anime">
                            <img src="{{ asset('assets/images/about-us-img-1.jpg') }}" alt="">
                        </figure>
                    </div>
                    <div class="about-us-img-2">
                        <figure class="image-anime">
                            <img src="{{ asset('assets/images/about-us-img-2.jpg') }}" alt="">
                        </figure>
                    </div>
                    <div class="about-experience-box">
                        <div class="icon-box">
                            <img src="{{ asset('assets/images/icon-company-experience.svg') }}" alt="">
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="about-us-content">
                    <div class="section-title">
                        <h3 class="wow fadeInUp">A Clínica</h3>
                        <h2 class="text-anime-style-2" data-cursor="-opaque">
                            Cuidando do seu sonho à cada batida do <span>coração</span>
                        </h2>
                        <p class="wow fadeInUp" data-wow-delay="0.2s">
                            Nossa clínica está ao seu lado em cada etapa da gestação, oferecendo tecnologia de ponta e
                            atendimento humanizado para garantir tranquilidade, segurança e carinho a você e à sua
                            família. Aqui, celebramos o início de novas vidas, ajudando a transformar o sonho da família
                            perfeita em realidade.
                        </p>
                    </div>
                    <div class="about-us-body">
                        <div class="about-list-btn">
                            <div class="about-list wow fadeInUp" data-wow-delay="0.4s">
                                <ul>
                                    <li>Somos especialistas e medicina fetal</li>
                                    <li>Histórico comprovado de resultados bem-sucedidos</li>
                                </ul>
                            </div>
                            <div class="about-btn wow fadeInUp" data-wow-delay="0.6s">
                                <a href="{{ url('clinica') }}" class="btn-default">Saiba Mais</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- About Us Section End -->

<!-- CTA Box Section Start -->
<div class="cta-box bg-section dark-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-9">
                <div class="cta-content">
                    <div class="section-title">
                        <h3 class="wow fadeInUp">Onde estamos?</h3>
                        <h2 class="text-anime-style-2" data-cursor="-opaque">
                            Com muito carinho, estamos ao seu lado em cada momento, cuidando do seu sonho com atenção,
                            respeito e amor.
                        </h2>
                    </div>
                    <div class="cta-content-body">
                        <div class="cta-contact-item wow fadeInUp" data-wow-delay="0.2s">
                            <div class="cta-contact-header">
                                <img src="{{ asset('assets/images/icon-phone-white.svg') }}" alt="...">
                                <h3>Telefone:</h3>
                            </div>
                            <div class="cta-contact-item-content">
                                <p><a href="tel:24998386145">(24) 99838-6145</a></p>
                            </div>
                        </div>
                        <div class="cta-contact-item wow fadeInUp" data-wow-delay="0.4s">
                            <div class="cta-contact-header">
                                <img src="{{ asset('assets/images/icon-mail.svg') }}" alt="">
                                <h3>E-mail Us:</h3>
                            </div>
                            <div class="cta-contact-item-content">
                                <p><a href="mailto:agenda@agapidiagnosticos.com">agenda@agapidiagnosticos.com</a></p>
                            </div>
                        </div>
                        <div class="cta-contact-item wow fadeInUp" data-wow-delay="0.6s">
                            <div class="cta-contact-header">
                                <img src="{{ asset('assets/images/icon-location-white.svg') }}" alt="">
                                <h3>Endereço:</h3>
                            </div>
                            <div class="cta-contact-item-content">
                                <p>
                                    Rua 40 Número 2 - Shopping 33, Torre 5 (Sala 1110 e 1111), Vila Santa Cecília, Volta
                                    Redonda
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="cta-btn">
                        <a href="#" class="btn-default btn-highlighted">
                            <i class="fi fi-brands-whatsapp"></i> Fale pelo Whatsapp
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- CTA Box Section End -->

<!-- Our Services Section Start -->
<div class="our-services bg-section">
    <div class="container">
        <div class="row section-row align-items-center">
            <div class="col-lg-6">
                <div class="section-title">
                    <h3 class="wow fadeInUp">O que oferecemos?</h3>
                    <h2 class="text-anime-style-2" data-cursor="-opaque">Conheça Nossas <span>Especialidades</span></h2>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="section-content-btn">
                    <div class="section-title-content wow fadeInUp" data-wow-delay="0.2s">
                        <p>
                            Nossa clínica reúne tecnologia avançada e uma equipe comprometida para oferecer um
                            atendimento acolhedor e de qualidade. Aqui, cada paciente é tratado com respeito e atenção,
                            proporcionando segurança e tranquilidade em todos os momentos do cuidado. Seu bem-estar é
                            nossa prioridade!
                        </p>
                    </div>
                    <div class="section-btn wow fadeInUp" data-wow-delay="0.4s">
                        <a href="#" class="btn-default">Ver Tudo</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row service-item-list">
            <div class="col-lg-3 col-md-6">
                <div class="service-item active wow fadeInUp">
                    <div class="service-image">
                        <img src="{{ asset('assets/images/service-1.jpg') }}" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="{{ asset('assets/images/icon-service-1.svg') }}" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom transvaginal ginecológico</a></h3>
                                <p>
                                    Avalia o útero e os ovários, assim como a presença de outras estruturas como massas,
                                    cistos e tumores pélvicos.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="service-item wow fadeInUp" data-wow-delay="0.2s">
                    <div class="service-image">
                        <img src="{{ asset('assets/images/service-1.jpg') }}" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="{{ asset('assets/images/icon-service-2.svg') }}" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom transvaginal de primeiro trimestre</a></h3>
                                <p>
                                    É o primeiro ultrassom da gestação e deve ser realizado preferencialmente após 7
                                    semanas, porque nesse momento já é possível visualizar embrião e batimentos
                                    cardíacos.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="service-item wow fadeInUp" data-wow-delay="0.4s">
                    <div class="service-image">
                        <img src="{{ asset('assets/images/service-1.jpg') }}" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="{{ asset('assets/images/icon-service-3.svg') }}" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom morfológico de 1º trimestre</a></h3>
                                <p>
                                    Deve ser realizado entre 11 semanas e 3 dias e 14 semanas, preferencialmente na 12ª
                                    semana, pelas vias abdominal e transvaginal.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="service-item wow fadeInUp" data-wow-delay="0.6s">
                    <div class="service-image">
                        <img src="{{ asset('assets/images/service-1.jpg') }}" alt="">
                    </div>
                    <div class="service-body">
                        <div class="icon-box">
                            <img src="{{ asset('assets/images/icon-service-4.svg') }}" alt="">
                        </div>
                        <div class="service-content">
                            <div class="service-content-info">
                                <h3><a href="#">Ultrassom morfológico de 2º trimestre</a></h3>
                                <p>
                                    Realizado preferencialmente entre 20 e 24 semanas de gestação, seu objetivo
                                    principal é avaliar a anatomia fetal de forma detalhada e detectar possíveis
                                    malformações.
                                </p>
                            </div>
                            <div class="service-readmore-btn">
                                <a href="#"><i class="fa-solid fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="section-footer-text wow fadeInUp" data-wow-delay="1s">
                    <p>
                        <span>[icone bebe]</span> Vamos agendar uma consulta? <a href="#">Clique aqui</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Our Services Section End -->

<!-- Footer Start -->
@include('public.components.footer')
<!-- Footer End -->

@include('public.components.scripts')
</body>

</html>
