<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ClinicaController;
use App\Http\Controllers\CorpoClinicoController;
use App\Http\Controllers\EspecialidadesController;
use App\Http\Controllers\ContatoController;
use App\Http\Controllers\PoliticaPrivacidadeController;
use App\Http\Controllers\NewsletterController;

Route::get('/', [HomeController::class, 'index'])->name('public.home');
Route::get('/clinica', [ClinicaController::class, 'index'])->name('public.clinica');
Route::get('/corpo-clinico', [CorpoClinicoController::class, 'index'])->name('public.corpo-clinico');
Route::get('/especialidades', [EspecialidadesController::class, 'index'])->name('public.especialidade');

Route::get('/contato', [ContatoController::class, 'index'])->name('public.contato');
Route::post('/contato/sendmail', [ContatoController::class, 'sendMail'])->name('enviar.formulario.contato');

Route::get('/politica-privacidade', [PoliticaPrivacidadeController::class, 'index'])->name('public.politica.privacidade');

Route::post('/newsletter/create', [NewsletterController::class, 'create'])->name('public.newsletter.create');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
