<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <?php echo $__env->make('public.components.meta-tags', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Page Title -->
    <title>Agapi | Ultrassonografia e Medicina Fetal - A Clínica</title>
    <!-- Favicon Icon -->
    <?php echo $__env->make('public.components.favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('public.components.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
<!-- Header Start -->
<?php echo $__env->make('public.components.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Header End -->

<!-- Page Header Section Start -->
<div class="page-header bg-section parallaxie">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-header-box">
                    <h1 class="text-anime-style-2" data-cursor="-opaque">A Clínica</h1>
                    <nav class="wow fadeInUp" data-wow-delay="0.25s">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">home</a></li>
                            <li class="breadcrumb-item">/</li>
                            <li class="breadcrumb-item active" aria-current="page"><span>A Clínica</span></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Page Header Section End -->

<!-- About Us Section Start -->
<div class="about-us">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="about-us-images">
                    <div class="about-us-img-1">
                        <figure class="image-anime">
                            <img src="<?php echo e(asset('assets/images/about-us-img-1.jpg')); ?>" alt="...">
                        </figure>
                    </div>
                    <div class="about-us-img-2">
                        <figure class="image-anime">
                            <img src="<?php echo e(asset('assets/images/about-us-img-2.jpg')); ?>" alt="...">
                        </figure>
                    </div>
                    <div class="about-experience-box">
                        <div class="icon-box">
                            <img src="<?php echo e(asset('assets/images/icon-company-experience.svg')); ?>" alt="...">
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="about-us-content">
                    <div class="section-title">
                        <h3 class="wow fadeInUp">A Clínica</h3>
                        <h2 class="text-anime-style-2" data-cursor="-opaque">
                            Cuidando do seu sonho à cada batida do <span>coração</span>
                        </h2>
                        <p class="wow fadeInUp" data-wow-delay="0.2s">
                            A AGAPI é uma clínica especializada em ultrassonografia obstétrica e medicina fetal que quer
                            proporcionar a você uma experiência única de cuidado.
                            Nós utilizamos equipamento de ultrassom novo, moderno e com imagens de alta resolução, além
                            do mais, estamos em constante atualização na área de cuidado materno-fetal, para oferecer a
                            melhor assistência possível para você e sua gestação.
                        </p>
                        <p class="wow fadeInUp" data-wow-delay="0.2s">
                            Preparamos um ambiente agradável e acolhedor para que você e sua família sejam atendidos com
                            tranquilidade e não se preocupem com nada mais além do exame. Queremos tornar o encontro de
                            cada um que chegar até a AGAPI um momento único, especial e exclusivo.
                        </p>
                    </div>
                    <div class="about-us-body">
                        <div class="about-list-btn">
                            <div class="about-list wow fadeInUp" data-wow-delay="0.4s">
                                <ul>
                                    <li>Somos especialistas em medicina fetal</li>
                                    <li>Histórico comprovado de resultados bem-sucedidos</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- About Us Section End -->

<!-- Our Facts Section Start -->
<div class="our-facts bg-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="fact-content">
                    <div class="section-title">
                        <h3 class="wow fadeInUp">Nossa história</h3>
                        <h2 class="text-anime-style-2" data-cursor="-opaque">Como surgiu a <span>AGAPI?</span></h2>
                        <p class="wow fadeInUp" data-wow-delay="0.2s">
                            A Agapi surgiu da paixão que a Dra Luciana Santanna sente pela medicina fetal. A Medicina
                            Fetal é uma subespecialidade da ginecologia e obstetrícia que permite através da
                            ultrassonografia diagnosticar anomalias fetais, rastrear/evitar desfechos desfavoráveis e
                            oferecer tratamento adequado para determinadas alterações, sendo algumas ainda intraútero.
                            Auxilia no seguimento da gestação, sempre visando o bem-estar do binômio mãe-feto,
                            garantindo assim uma assistência obstétrica de excelência.
                        </p>
                    </div>
                    <div class="fact-image">
                        <figure class="image-anime reveal">
                            <img src="<?php echo e(asset('assets/images/fact-img-1.jpg')); ?>" alt="">
                        </figure>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="fact-info-box">
                    <div class="fact-image">
                        <figure class="image-anime reveal">
                            <img src="<?php echo e(asset('assets/images/fact-img-2.jpg')); ?>" alt="">
                        </figure>
                    </div>
                    <div class="fact-body">
                        <div class="wow fadeInUp" data-wow-delay="0.2s">
                            <p class="wow fadeInUp" data-wow-delay="0.3s">
                                O nome <strong>AGAPI</strong> representa o que move a especialidade medicina fetal. Nós
                                buscamos um nome
                                que fizesse alusão à relação de mãe-filho.
                            </p>
                            <p class="wow fadeInUp" data-wow-delay="0.4s">
                                <strong>“AGAPI”</strong> está relacionado ao conceito grego de amor incondicional ou
                                divino,
                                frequentemente associado ao amor altruísta. Tradicionalmente, o amor de mãe é visto como
                                exemplo terreno desse amor ágape, pois é um amor que cuida, protege, sacrifica e dá sem
                                limites e sem esperar nada em troca.
                            </p>
                            <p class="wow fadeInUp" data-wow-delay="0.5s">
                                E aqui, nós temos o privilégio de vivenciar esse amor diariamente.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Our Facts Section End -->

<!-- Photo Gallery Section Start -->
<div class="page-gallery">
    <div class="container">
        <div class="row section-row align-items-center">
            <div class="col-lg-6">
                <div class="section-title">
                    <h3 class="wow fadeInUp">Galeria</h3>
                    <h2 class="text-anime-style-2" data-cursor="-opaque">Veja nossa <span>Clínica</span></h2>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="section-title-content wow fadeInUp" data-wow-delay="0.2s">
                    <p>
                        Ambientes acolhedores com tecnologia de ponta e dedicação da nossa equipe. Conheça um pouco
                        mais da estrutura da clínica, pensada para oferecer conforto, segurança e qualidade em cada
                        atendimento. Cada imagem reflete o compromisso com o bem-estar e a excelência no cuidado aos
                        nossos pacientes.
                    </p>
                </div>
            </div>
        </div>
        <div class="row gallery-items page-gallery-box">
            <div class="col-lg-4 col-6">
                <div class="photo-gallery wow fadeInUp" data-wow-delay="0.6s">
                    <a href="https://placehold.co/1200x800" data-cursor-text="View">
                        <figure class="image-anime">
                            <img src="https://placehold.co/1200x800" alt="">
                        </figure>
                    </a>
                </div>
            </div>

            <div class="col-lg-4 col-6">
                <div class="photo-gallery wow fadeInUp" data-wow-delay="0.8s">
                    <a href="https://placehold.co/1200x800" data-cursor-text="View">
                        <figure class="image-anime">
                            <img src="https://placehold.co/1200x800" alt="">
                        </figure>
                    </a>
                </div>
            </div>

            <div class="col-lg-4 col-6">
                <div class="photo-gallery wow fadeInUp" data-wow-delay="1s">
                    <a href="https://placehold.co/1200x800" data-cursor-text="View">
                        <figure class="image-anime">
                            <img src="https://placehold.co/1200x800" alt="">
                        </figure>
                    </a>
                </div>
            </div>

            <div class="col-lg-4 col-6">
                <div class="photo-gallery wow fadeInUp" data-wow-delay="1.2s">
                    <a href="https://placehold.co/1200x800" data-cursor-text="View">
                        <figure class="image-anime">
                            <img src="https://placehold.co/1200x800" alt="">
                        </figure>
                    </a>
                </div>
            </div>

            <div class="col-lg-4 col-6">
                <div class="photo-gallery wow fadeInUp" data-wow-delay="1.4s">
                    <a href="https://placehold.co/1200x800" data-cursor-text="View">
                        <figure class="image-anime">
                            <img src="https://placehold.co/1200x800" alt="">
                        </figure>
                    </a>
                </div>
            </div>

            <div class="col-lg-4 col-6">
                <div class="photo-gallery wow fadeInUp" data-wow-delay="1.6s">
                    <a href="https://placehold.co/1200x800" data-cursor-text="View">
                        <figure class="image-anime">
                            <img src="https://placehold.co/1200x800" alt="">
                        </figure>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Photo Gallery Section End -->

<!-- Our Approach Section Start -->
<div class="bg-section" style="padding: 100px 0">
    <div class="container">
        <div class="row section-row align-items-center">
            <div class="col-lg-6">
                <div class="section-title">
                    <h3 class="wow fadeInUp">Institucional</h3>
                    <h2 class="text-anime-style-2" data-cursor="-opaque">
                        Misão e Visão
                    </h2>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="section-title-content wow fadeInUp" data-wow-delay="0.2s">
                    <p>
                        Na busca contínua pela excelência no cuidado à saúde, nossa clínica orienta sua atuação por
                        princípios que vão além da tecnologia e do conhecimento técnico. Acreditamos que o compromisso
                        com nossos pacientes se reflete tanto no propósito que nos motiva diariamente quanto no futuro
                        que almejamos construir para todos aqueles que confiam em nossos serviços.
                    </p>
                </div>
            </div>
        </div>

        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="our-approach-image">
                    <figure class="image-anime reveal">
                        <img src="<?php echo e(asset('assets/images/appointment-image.jpg')); ?>" alt="">
                    </figure>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="our-approach-content">
                    <div class="approach-item-box">
                        <div class="approach-item wow fadeInUp" data-wow-delay="0.4s">
                            <div class="icon-box">
                                <img src="<?php echo e(asset('assets/images/icon-mission.svg')); ?>" alt="">
                            </div>
                            <div class="approach-item-content">
                                <h3>Nossa Missão</h3>
                                <p>
                                    Oferecer serviços de ultrassonografia com precisão, segurança e agilidade,
                                    promovendo um atendimento humanizado e individualizado para contribuir de forma
                                    positiva na saúde e bem-estar dos nossos pacientes.
                                </p>
                            </div>
                        </div>
                        <div class="approach-item wow fadeInUp" data-wow-delay="0.6s">
                            <div class="icon-box">
                                <img src="<?php echo e(asset('assets/images/icon-vision.svg')); ?>" alt="">
                            </div>
                            <div class="approach-item-content">
                                <h3>Nossa Visão</h3>
                                <p>
                                    Ser referência em diagnóstico por imagem, reconhecida pela excelência técnica,
                                    inovação constante e compromisso com a qualidade do atendimento, tornando-se a
                                    escolha preferencial de pacientes e profissionais da área da saúde.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Our Approach Section End -->

<!-- Footer Start -->
<?php echo $__env->make('public.components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Footer End -->

<?php echo $__env->make('public.components.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH C:\htdocs\agapi-site\resources\views/public/clinic.blade.php ENDPATH**/ ?>