<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Clube Libertas</title>
    <!-- favicons Icons -->
    <?php echo $__env->make('public/components/favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Styles -->
    <?php echo $__env->make('public/components/styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>

<!-- /.preloader -->
<div class="page-wrapper">
    <header class="main-header clearfix">
        <?php echo $__env->make('public/components/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </header>

    <div class="stricky-header stricked-menu main-menu">
        <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
    </div><!-- /.stricky-header -->

    <!--Main Slider Start-->
    <section class="main-slider">
        <div class="swiper-container thm-swiper__slider" data-swiper-options='{"slidesPerView": 1, "loop": true,
    "effect": "fade",
     "pagination": {
        "el": "#main-slider-pagination",
        "type": "bullets",
        "clickable": true
      },
    "navigation": {
        "nextEl": "#main-slider__swiper-button-next",
        "prevEl": "#main-slider__swiper-button-prev"
    },
    "autoplay": {
        "delay": 5000
    }}'>
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="image-layer"
                         style="background-image: url(assets/images/backgrounds/main-slider-1-1.jpg);">
                    </div>
                    <!-- /.image-layer -->
                    <div class="main-slider__social">
                        <a href="#">facebook</a>
                        <a href="#">instagram</a>
                    </div>
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="main-slider__content">
                                    <div class="main-slider__title-box-1">
                                        <h2>Não espere <br> acontecer</h2>
                                        <p class="text-white">Torne-se nosso associado e fique protegido. <br> Você paga
                                            até 40% mais
                                            barato que o seguro convencional.</p>
                                        <div class="main-slider__title-box-2">
                                            <h2>Não espere <br> acontecer</h2>
                                        </div>
                                    </div>
                                    <a href="#" class="thm-btn mt-4">Saiba Mais</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Main Slider End-->

    <!--Services One Start-->
    <section class="services-one">
        <div class="services-one-shape" style="background-image: url(assets/images/shapes/services-one-shape.png)">
        </div>
        <div class="container">
            <div class="services-one__top">
                <div class="row">
                    <div class="col-xl-7 col-lg-6">
                        <div class="services-one__top-left">
                            <div class="section-title text-left">
                                <span class="section-title__tagline">Fique</span>
                                <h2 class="section-title__title">Sempre <br> tranquilo</h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-6">
                        <div class="services-one__top-right">
                            <p class="services-one__top-text">
                                Você se associa e garante a proteção para o seu veículo sem burocracia. É rápido e
                                fácil. Conheça os nossos principais benefícios.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="services-one__bottom">
                <div class="row">
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="100ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <h3 class="services-one__title">
                                <a href="<?php echo e(url('/beneficios')); ?>">
                                    Chaveiro
                                </a>
                            </h3>
                            <div class="services-one__icon">
                                <img src="<?php echo e(asset('assets/images/icon/chaveiro.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <div class="services-one__count"></div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <h3 class="services-one__title">
                                <a href="<?php echo e(url('/beneficios')); ?>">
                                    Reboque
                                </a>
                            </h3>
                            <div class="services-one__icon">
                                <img src="<?php echo e(asset('assets/images/icon/reboque-de-caminhao.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <div class="services-one__count"></div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="300ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <h3 class="services-one__title">
                                <a href="<?php echo e(url('/beneficios')); ?>">
                                    Táxi
                                </a>
                            </h3>
                            <div class="services-one__icon">
                                <img src="<?php echo e(asset('assets/images/icon/taxi.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <div class="services-one__count"></div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="400ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <h3 class="services-one__title">
                                <a href="<?php echo e(url('/beneficios')); ?>">
                                    Troca de Pneus
                                </a>
                            </h3>
                            <div class="services-one__icon">
                                <img src="<?php echo e(asset('assets/images/icon/robusto.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <div class="services-one__count"></div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="500ms">
                        <!--Services One Single-->
                        <div class="services-one__single">
                            <h3 class="services-one__title">
                                <a href="<?php echo e(url('/beneficios')); ?>">
                                    Pane Seca
                                </a>
                            </h3>
                            <div class="services-one__icon">
                                <img src="<?php echo e(asset('assets/images/icon/bomba-de-gasolina-alt.svg')); ?>" width="60" height="60" alt="..." >
                            </div>
                            <div class="services-one__count"></div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="600ms">
                        <!--Services One Single-->
                        <div class="services-one__view-all">
                            <div class="services-one__view-all-title-box">
                                <h3 class="services-one__view-all-title">
                                    <a href="<?php echo e(url('/beneficios')); ?>">
                                        Ver todos os benefícios
                                    </a>
                                </h3>
                            </div>
                            <div class="services-one__view-all-arrow">
                                <a href="<?php echo e(url('/beneficios')); ?>"><span class="icon-arrow-right"></span></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Services One End-->

    <!--Welcome One Start-->
    <section class="welcome-one">
        <div class="welcome-one-shape wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms"><img
                src="assets/images/shapes/welcom-one-shape.png" alt=""></div>
        <div class="container">
            <div class="row">
                <div class="col-xl-6 wow slideInLeft" data-wow-delay="100ms" data-wow-duration="2500ms">
                    <div class="welcome-one__left">
                        <div class="welcome-one__img-box">
                            <div class="welcome-one__img">
                                <img src="assets/images/resources/welcome-one-img-1.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="welcome-one__right">
                        <div class="section-title text-left">
                            <span class="section-title__tagline"></span>
                            <h2 class="section-title__title">Proteção online para você!!!</h2>
                        </div>
                        <p class="welcome-one__right-text">
                            No Clube Libertas, você desfruta da liberdade de se associar no momento que preferir,
                            garantindo flexibilidade e comodidade para fazer parte do clube de acordo com suas
                            necessidades e interesses.
                        </p>
                        <div class="welcome-one__bottom">
                            <div class="row">
                                <div class="col-xl-6 col-lg-6 col-md-6">
                                    <div class="welcome-one__bottom-left">
                                        <h4 class="welcome-one__bottom-title">
                                            Está tudo na palma da mão, 100% online pelo nosso aplicativo. Na Escudo você
                                            tem Proteção e Benefícios sempre que precisar e onde estiver.
                                        </h4>
                                        <ul class="list-unstyled welcome-one__points">
                                            <li>
                                                <div class="icon">
                                                    <span class="icon-tick"></span>
                                                </div>
                                                <div class="text">
                                                    <p>Sem consulta SPC/SERASA</p>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="icon">
                                                    <span class="icon-tick"></span>
                                                </div>
                                                <div class="text">
                                                    <p>Proteção contra roubo/furto</p>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="icon">
                                                    <span class="icon-tick"></span>
                                                </div>
                                                <div class="text">
                                                    <p>Sem análise de perfil</p>
                                                </div>
                                            </li>
                                            <li>
                                                <div class="icon">
                                                    <span class="icon-tick"></span>
                                                </div>
                                                <div class="text">
                                                    <p>E muito mais</p>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6">
                                    <div class="welcome-one__bottom-right">
                                        <div class="welcome-one__bottom-right-content">
                                            <div class="welcome-one__bottom-right-icon">
                                                <span class="icon-help"></span>
                                            </div>
                                            <h4 class="welcome-one__bottom-right-title">
                                                Estamos sempre preparados para te ajudar!
                                            </h4>
                                            <a href="#" class="thm-btn welcome-one__btn text-center">Solicite uma
                                                cotação</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Welcome One End-->

    <!--CTA One Start-->
    <section class="cta-one">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="cta-one__inner">
                        <div class="cta-one__box-1"></div>
                        <div class="cta-one__box-2"></div>
                        <div class="cta-one__left">
                            <div class="cta-one__icon">
                                <span class="icon-consulting"></span>
                            </div>
                            <div class="cta-one__title-box">
                                <h2 class="cta-one__title">
                                    Seu veículo protegido com a Libertas pra curtir a vida numa boa.
                                </h2>
                            </div>
                        </div>
                        <div class="cta-one__right">
                            <a href="#" class="thm-btn cta-one__btn text-center">
                                Quero me associar
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--CTA One End-->

    <!--Best Agency Start-->
    <section class="best-agency">
        <div class="best-agency-shape" style="background-image: url('assets/images/shapes/best-agency-shape.png')">
        </div>
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-6">
                    <div class="best-agency__left">
                        <div class="section-title text-left">
                            <span class="section-title__tagline">Ainda tem dúvidas?</span>
                            <h2 class="section-title__title">Por que se tornar um associado?</h2>
                        </div>
                        <ul class="list-unstyled best-agency__points">
                            <li>
                                <div class="icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="text">
                                    <p>Assistência Residencial</p>
                                </div>
                            </li>
                            <li>
                                <div class="icon">
                                    <span class="icon-check"></span>
                                </div>
                                <div class="text">
                                    <p>Assistência 24h</p>
                                </div>
                            </li>
                        </ul>
                        <div class="best-agency__experience">
                            <div class="best-agency__experience-icon">
                                <span class="icon-social-media"></span>
                            </div>
                            <div class="best-agency__experience-text-box">
                                <p class="best-agency__experience-text">
                                    Nossos membros têm acesso a uma variedade de benefícios
                                    disponíveis 24 horas por dia, onde quer que estejam. Conte com praticidade e
                                    vantagens exclusivas sempre ao seu alcance!
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="best-agency__right">
                        <div class="accrodion-grp" data-grp-name="faq-one-accrodion">
                            <div class="accrodion active">
                                <div class="accrodion-title">
                                    <h4>O Clube Libertas é uma seguradora?</h4>
                                </div>
                                <div class="accrodion-content">
                                    <div class="inner">
                                        <p>
                                            Não! Não somo seguradora. Somos uma associação de proteção veícular que
                                            fornece benefícios para os nosso associados em caso de eventos.
                                        </p>
                                    </div><!-- /.inner -->
                                </div>
                            </div>
                            <div class="accrodion">
                                <div class="accrodion-title">
                                    <h4>A partir de quando o veículo está protegido?</h4>
                                </div>
                                <div class="accrodion-content">
                                    <div class="inner">
                                        <p>
                                            Nosso associado poderá usufruir dos benefícios a partir da 0h do dia que
                                            sucedeu
                                            a aprovação da proposta de associação, cadastramento no sistema e
                                            compensação do pagamento do boleto bancário, cumulativamente.
                                        </p>
                                    </div><!-- /.inner -->
                                </div>
                            </div>
                            <div class="accrodion last-chiled">
                                <div class="accrodion-title">
                                    <h4>Em caso de eventos, o que devo fazer?</h4>
                                </div>
                                <div class="accrodion-content">
                                    <div class="inner">
                                        <p>
                                            Em caso de roubo, furto, acidentes, por exemplo, faça um boletim de
                                            ocorrência junto à delegacia e depois entre em contato com a nossa central de
                                            atendimento 24h para reportar o evento e seguir todo procedimento.
                                        </p>
                                    </div><!-- /.inner -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Best Agency End-->

    <!--Site Footer Start-->
    <?php echo $__env->make('public/components/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--Site Footer End-->

</div><!-- /.page-wrapper -->

<?php echo $__env->make('public/components/menu-mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('public/components/scroll-top', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Scripts -->
<?php echo $__env->make('public/components/scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html>
<?php /**PATH C:\htdocs\clube-libertas\resources\views/public/home.blade.php ENDPATH**/ ?>